<?PHP 
/**
* Markup to view any message that is not a draft.
* 
* Note that this view is intended to be used within the larger context of inbox/{@link template.php}, in conjunction with the 
* {@link _view_menu} partial.
*
* <code>
* $this->template->set('menu_partial', '_view_menu');
* $this->template->load('template', 'inbox/view', $data); 
* </code>
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

/*
 A few things to be aware of if we have time to work on this at some point or run into problems in this file:
 	- The way attachments are currently set up, we can't distinguish between a C32 XML file and a different XML file if we have both
	- If we have multiple attached images, we'll have duplicate hidden input fields, which is invalid HTML and may result in unexpected behavior.  
		(ditto if we have an image and a C32 file, etc.).  We may want to double-check that the input fields are necessary.
	- The hidden input fields are being echoed to the screen between <li>s in a <ul>, which is invalid HTML and may result in unexpected behavior. 
																							-- MG 2014-04-30 */
																													
//sent messages include icons to indicate delivery status; let's format them before we display the markup to keep the markup as clear as possible
//this will result in a $to and a $cc address
foreach(array('to', 'cc') as $recipient_type){
	if(!$message->sent){
		$$recipient_type = array_map('htmlentities', $message->addresses_for_display($recipient_type));
	}else{
		$$recipient_type = array();
		foreach($message->addresses_for_display($recipient_type) as $address){	 
			$markup = '<a style="text-decoration:none; color:#000000">' . htmlentities($address) . ' </a>'; //why are we putting the address in an <a>? 
			$markup .= '<img src="/images/email_icons/' . make_string_css_friendly($message->delivery_status($address)) . '.png" title="' . $message->delivery_status($address) . '">';
			array_push($$recipient_type, $markup); //wouldn't normally use array_push, but PHP doesn't seem to like [] with $$ syntax
		}
	}
}

?>
<input style="display:none;" id="current_user" value="<?PHP if(isset($status_enabled)){echo $user->id;}?>"/>
<input style="display:none;" id="display_name" value="<?PHP if(isset($status_enabled)){echo $user->cn;}?>"/>
<div id="msg_header">
	<div class="subject">
		<?php if(isset($status_enabled) && $status_enabled) echo $this->load->view('inbox/_assignment_link', compact('user', 'message', 'workflow_item'), TRUE); ?>
		<?php echo $message->subject_for_display(); ?>
	<?php if($message->importance != 'normal'): ?>
		<br />
		<span class="msg_priority">This message was sent with <?php echo ucfirst($message->importance) ?> importance.</span>
	<?php endif ?>
	</div>
	<div id="msg_subheader">
		<div class="date"><?php echo $message->timestamp_for_display() ?></div>
		<div class="addresses">
			<div class="address-item"><strong>From</strong>: <?php echo implode(', ', array_map('htmlentities', $message->addresses_for_display('sender')))  ?> </div>
				<div class="address-item"><strong>To</strong>: <?php echo implode(', ',  $to) ?></div>
				<?php if(!$message->property_is_empty('cc')): ?>
					<div class="address-item"><strong>CC</strong>: <?php echo implode(', ',  $cc) ?></div>
				<?php endif ?>
		</div>
	<?php if($message->has_attachments()): ?>
		<div class="attachments"> 
			<strong>Attachments</strong>: <br />
			<ul id="attachments-list">
		<?php foreach($message->attachment_files as $attachment): ?>
			<?php if(in_array($attachment->extension, array('jpeg', 'jpg', 'gif', 'png'))): ?>
				<input type="hidden" name="type" value="download/image" />
				<input type="hidden" name="msg_id" value="<?php echo $message->id ?>" />
				<li class="<?php echo $attachment->extension ?>"> 
					<a rel="gallery" title="<?php echo $attachment->filename ?>" class="lightbox" href="<?php echo $attachment->url ?>"><?php echo $attachment->filename  ?></a>
			<?php elseif($attachment->extension == 'pdf'): ?>
				<li class="<?php echo $attachment->extension ?>"> 
					<a target="_blank" title="<?php echo $attachment->filename ?>" href="<?php echo $attachment->url ?>"><?php echo $attachment->filename ?></a>
			<?php elseif($attachment->extension == 'xml' && isset($c32data)): ?>
					<input type="hidden" name="type" value="download/pdf" />
					<input type="hidden" name="msg_id" value="<?php echo $message->id ?>" />
					<li class="<?php echo $attachment->extension  ?> c32"> 
					<strong><?php echo $attachment->filename ?></strong> (<?php echo $c32data[$attachment->filename] ?>)
					(<a class="lightbox" title="<?php echo $attachment->filename ?>" href="<?php echo $attachment->url. '/?'.$this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash() ?>">View</a>)
					<?php if(array_key_exists($attachment->filename, $c32data)):
						//Only Show Save to DAS for C32 files and show date if report was previously saved
						$check_previously_saved_dash = $this->das_results_model->search_attachment_info($attachment->filename, $message->id)->result();
						if (isset($check_previously_saved_dash[0]->saved_date)): ?>
						(<a href="<?php echo '/inbox/save_to_das/'.$message->id.'/'.$attachment->filename.'/?'.$this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash(); ?>">Save to DAS</a> - Last Saved on <?php echo date('m/d/y h:i:s A',$check_previously_saved_dash[0]->saved_date); ?>)
						<?php else: ?>
						(<a href="<?php echo '/inbox/save_to_das/'.$message->id.'/'.$attachment->filename.'/?'.$this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash(); ?>">Save to DAS</a>)
						<?php endif ?>
					<?php endif ?>
					(<a href="<?php echo $attachment->url .'/download/?'.$this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash() ?>">Download</a>)
					(<a href="<?php echo $attachment->url .'/download/pdf/?'.$this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash() ?>">Download as PDF</a>)
			<?php else: ?>
				<li class="<?php echo $attachment->extension ?>">
					<a href="<?php echo $attachment->url .'/?'.$this->security->get_csrf_token_name().'='.$this->security->get_csrf_hash() ?>"><?php echo  $attachment->filename ?></a>
			<?php endif ?>
					(<?php echo byte_format($attachment->bytes) ?>) 
				</li>
		<?php endforeach ?>
			</ul>
		</div>
	</div>
	<?php endif ?>
</div>
<div id="msg_body"><?php echo $message->body_for_display ?></div>